<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';

// Check if user is logged in
requireLogin();

$pageTitle = 'جزئیات سفارش';
$orderId = $_GET['id'] ?? 0;

if (!$orderId) {
    header('Location: /dashboard.php');
    exit;
}

// Get order details
$order = getOrderById($orderId);

if (!$order || $order['user_id'] != $_SESSION['user_id']) {
    header('Location: /dashboard.php');
    exit;
}

include __DIR__ . '/includes/header.php';
?>

<style>
.order-container {
    max-width: 800px;
    margin: 0 auto;
}

.order-box {
    background: white;
    border-radius: 12px;
    padding: 30px;
    margin-bottom: 25px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
}

.order-box h2 {
    color: #667eea;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 2px solid #f0f0f0;
}

.order-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 25px;
}

.order-number {
    font-size: 24px;
    font-weight: bold;
    color: #333;
}

.status-badge {
    padding: 10px 25px;
    border-radius: 25px;
    font-size: 15px;
    font-weight: 600;
}

.status-badge.pending {
    background: #fff3cd;
    color: #856404;
}

.status-badge.paid {
    background: #d4edda;
    color: #155724;
}

.status-badge.failed {
    background: #f8d7da;
    color: #721c24;
}

.status-badge.cancelled {
    background: #e2e3e5;
    color: #383d41;
}

.detail-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin: 20px 0;
}

.detail-item {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
}

.detail-item strong {
    display: block;
    color: #999;
    font-size: 13px;
    margin-bottom: 8px;
}

.detail-item span {
    display: block;
    color: #333;
    font-size: 16px;
    font-weight: 600;
}

.price-highlight {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
    border-radius: 10px;
    text-align: center;
    margin: 20px 0;
}

.price-highlight .label {
    font-size: 14px;
    opacity: 0.9;
    margin-bottom: 10px;
}

.price-highlight .amount {
    font-size: 32px;
    font-weight: bold;
}

.esim-box {
    background: #e7f3ff;
    border: 2px solid #667eea;
    border-radius: 10px;
    padding: 25px;
    margin: 20px 0;
}

.esim-box h3 {
    color: #667eea;
    margin-bottom: 20px;
    text-align: center;
}

.qr-code-container {
    text-align: center;
    margin: 20px 0;
}

.qr-code-container img {
    max-width: 300px;
    border: 3px solid #667eea;
    border-radius: 10px;
    padding: 10px;
    background: white;
}

.activation-code {
    background: white;
    border: 2px dashed #667eea;
    border-radius: 8px;
    padding: 15px;
    margin: 15px 0;
    text-align: center;
    font-family: monospace;
    font-size: 18px;
    font-weight: bold;
    color: #667eea;
    word-break: break-all;
}

.btn {
    display: inline-block;
    padding: 12px 25px;
    background: #667eea;
    color: white;
    text-decoration: none;
    border-radius: 8px;
    margin: 5px;
    transition: background 0.3s;
}

.btn:hover {
    background: #5568d3;
}

.btn-success {
    background: #28a745;
}

.btn-success:hover {
    background: #218838;
}

.info-alert {
    background: #fff3cd;
    border: 1px solid #ffc107;
    color: #856404;
    padding: 15px;
    border-radius: 8px;
    margin: 20px 0;
}

@media (max-width: 768px) {
    .detail-grid {
        grid-template-columns: 1fr;
    }
    
    .order-header {
        flex-direction: column;
        gap: 15px;
    }
}
</style>

<div class="container">
    <div class="order-container">
        <div class="order-box">
            <div class="order-header">
                <div class="order-number">
                    <i class="fas fa-file-invoice"></i>
                    سفارش #<?php echo $order['id']; ?>
                </div>
                <?php
                $statusLabels = [
                    'pending' => 'در انتظار پرداخت',
                    'paid' => 'پرداخت شده',
                    'failed' => 'ناموفق',
                    'cancelled' => 'لغو شده'
                ];
                $statusLabel = $statusLabels[$order['status']] ?? $order['status'];
                ?>
                <span class="status-badge <?php echo $order['status']; ?>">
                    <?php echo $statusLabel; ?>
                </span>
            </div>

            <h2><i class="fas fa-info-circle"></i> اطلاعات سفارش</h2>

            <div class="detail-grid">
                <div class="detail-item">
                    <strong><i class="fas fa-sim-card"></i> نام بسته</strong>
                    <span><?php echo htmlspecialchars($order['package_name']); ?></span>
                </div>
                <div class="detail-item">
                    <strong><i class="fas fa-globe"></i> کشور</strong>
                    <span><?php echo htmlspecialchars($order['country_name']); ?></span>
                </div>
                <div class="detail-item">
                    <strong><i class="fas fa-database"></i> حجم داده</strong>
                    <span><?php echo htmlspecialchars($order['data_amount']); ?></span>
                </div>
                <div class="detail-item">
                    <strong><i class="fas fa-calendar-alt"></i> مدت اعتبار</strong>
                    <span><?php echo $order['validity_days']; ?> روز</span>
                </div>
                <div class="detail-item">
                    <strong><i class="fas fa-clock"></i> تاریخ ثبت</strong>
                    <span><?php echo date('Y/m/d H:i', strtotime($order['created_at'])); ?></span>
                </div>
                <?php if ($order['paid_at']): ?>
                    <div class="detail-item">
                        <strong><i class="fas fa-check-circle"></i> تاریخ پرداخت</strong>
                        <span><?php echo date('Y/m/d H:i', strtotime($order['paid_at'])); ?></span>
                    </div>
                <?php endif; ?>
            </div>

            <div class="price-highlight">
                <div class="label">مبلغ <?php echo $order['status'] === 'paid' ? 'پرداخت شده' : 'قابل پرداخت'; ?></div>
                <div class="amount"><?php echo formatPrice($order['price_irr']); ?> تومان</div>
                <?php if ($order['payment_ref_id']): ?>
                    <div style="margin-top: 15px; font-size: 14px; opacity: 0.9;">
                        شماره پیگیری: <?php echo htmlspecialchars($order['payment_ref_id']); ?>
                    </div>
                <?php endif; ?>
            </div>

            <?php if ($order['status'] === 'paid' && $order['qr_code']): ?>
                <div class="esim-box">
                    <h3><i class="fas fa-qrcode"></i> اطلاعات eSIM شما</h3>
                    
                    <div class="qr-code-container">
                        <img src="<?php echo htmlspecialchars($order['qr_code']); ?>" alt="QR Code">
                        <p style="margin-top: 15px; color: #666;">
                            برای نصب eSIM، این QR Code را با دوربین گوشی خود اسکن کنید
                        </p>
                    </div>

                    <?php if ($order['iccid']): ?>
                        <div class="detail-item" style="margin: 15px 0;">
                            <strong>ICCID:</strong>
                            <span style="font-family: monospace;"><?php echo htmlspecialchars($order['iccid']); ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if ($order['activation_code']): ?>
                        <div>
                            <strong style="display: block; margin-bottom: 10px; color: #667eea;">کد فعال‌سازی دستی:</strong>
                            <div class="activation-code">
                                <?php echo htmlspecialchars($order['activation_code']); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div style="text-align: center; margin-top: 20px;">
                        <a href="mailto:?subject=eSIM خریداری شده&body=اطلاعات eSIM در پیوست ارسال شده" class="btn btn-success">
                            <i class="fas fa-envelope"></i>
                            ارسال به ایمیل
                        </a>
                        <button onclick="window.print()" class="btn">
                            <i class="fas fa-print"></i>
                            چاپ اطلاعات
                        </button>
                    </div>
                </div>

            <?php elseif ($order['status'] === 'pending'): ?>
                <div class="info-alert">
                    <i class="fas fa-info-circle"></i>
                    این سفارش هنوز پرداخت نشده است. برای تکمیل خرید، روی دکمه زیر کلیک کنید.
                </div>
                <div style="text-align: center;">
                    <a href="/proxy-payment.php?order=<?php echo $order['id']; ?>" class="btn btn-success">
                        <i class="fas fa-credit-card"></i>
                        پرداخت <?php echo formatPrice($order['price_irr']); ?> تومان
                    </a>
                </div>

            <?php elseif ($order['status'] === 'failed' || $order['status'] === 'cancelled'): ?>
                <div class="info-alert" style="background: #f8d7da; border-color: #f5c6cb; color: #721c24;">
                    <i class="fas fa-exclamation-triangle"></i>
                    این سفارش <?php echo $order['status'] === 'failed' ? 'ناموفق' : 'لغو شده'; ?> است.
                    می‌توانید سفارش جدید ثبت کنید.
                </div>
                <div style="text-align: center;">
                    <a href="/checkout.php?package=<?php echo urlencode($order['package_code']); ?>&country=<?php echo urlencode($order['country_code']); ?>" class="btn btn-success">
                        <i class="fas fa-redo"></i>
                        سفارش مجدد
                    </a>
                </div>
            <?php endif; ?>

            <div style="text-align: center; margin-top: 25px;">
                <a href="/dashboard.php" class="btn">
                    <i class="fas fa-arrow-right"></i>
                    بازگشت به داشبورد
                </a>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>

