<?php
/**
 * Migration: Add esim_status column to orders table
 * Run this file once to add the new column
 */

require_once __DIR__ . '/config/database.php';

$conn = getDBConnection();

// Check if column already exists
$result = $conn->query("SHOW COLUMNS FROM orders LIKE 'esim_status'");

if ($result->num_rows == 0) {
    // Column doesn't exist, add it
    $sql = "ALTER TABLE orders ADD COLUMN esim_status VARCHAR(20) DEFAULT 'active' AFTER activation_code";
    
    if ($conn->query($sql)) {
        echo "✅ Column 'esim_status' added successfully!<br>";
    } else {
        echo "❌ Error adding column: " . $conn->error . "<br>";
    }
} else {
    echo "ℹ️ Column 'esim_status' already exists.<br>";
}

$conn->close();

echo "<br><a href='/admin/esims.php'>Go to eSIM Management</a>";
?>

